<?php
// example.php

require_once 'DatabaseManager.php';

// Create or retrieve the first connection
$db1 = DatabaseManager::getConnection(
    'db1',       // name/key for this connection
    'localhost', // host
    'database1', // db name
    'user1',     // db user
    'pass1'      // db password
);

// Create or retrieve the second connection
$db2 = DatabaseManager::getConnection(
    'db2',
    'localhost',
    'database2',
    'user2',
    'pass2'
);

// TEST: Query using $db1
try {
    $stmt = $db1->query("SELECT 'Hello from DB1' AS greeting");
    $row = $stmt->fetch();
    echo $row['greeting'], PHP_EOL; // "Hello from DB1"
} catch (PDOException $e) {
    echo "DB1 Error: " . $e->getMessage() . PHP_EOL;
}

// TEST: Query using $db2
try {
    $stmt = $db2->query("SELECT 'Hello from DB2' AS greeting");
    $row = $stmt->fetch();
    echo $row['greeting'], PHP_EOL; // "Hello from DB2"
} catch (PDOException $e) {
    echo "DB2 Error: " . $e->getMessage() . PHP_EOL;
}

// (Optional) Close one connection:
// DatabaseManager::closeConnection('db1');

// (Optional) Close all connections:
// DatabaseManager::closeAllConnections();

// If you do not manually close, PDO with ATTR_PERSISTENT => true will
// attempt to reuse the underlying connection for future requests, depending
// on your PHP/Apache/FPM configuration.
